//
window.addEvent('load', function() {
	// add the loaded class to <body> with small delay to avoid low framerate	
	setTimeout(function() {
		document.body.addClass('loaded');
	}, 500);
	// smooth anchor scrolling
	new SmoothScroll({
		'duration': 1000,
		'wheelStops': false
	}); 
	// style area
	if(document.id('gkStyleArea')){
		document.id('gkStyleArea').getElements('a').each(function(element,i){
			element.addEvent('click',function(e){
	            e.stop();
				changeStyle(i+1);
			});
		});
	}
	
	if(document.id('gkStyleSwitcher')){
		document.id('gkStyleSwitcher').getElements('a').each(function(element,i){
			element.addEvent('click',function(e){
	            e.stop();
				changeStyle(i+1);
			});
		});
	}
	// font-size switcher
	if(document.id('gkTools') && document.id('gkMainbody')) {
		var current_fs = 100;
		var content_fx = new Fx.Tween(document.id('gkMainbody'), { property: 'font-size', unit: '%', duration: 200 }).set(100);
		document.id('gkToolsInc').addEvent('click', function(e){ 
			e.stop(); 
			if(current_fs < 150) { 
				content_fx.start(current_fs + 10); 
				current_fs += 10; 
			} 
		});
		document.id('gkToolsReset').addEvent('click', function(e){ 
			e.stop(); 
			content_fx.start(100); 
			current_fs = 100; 
		});
		document.id('gkToolsDec').addEvent('click', function(e){ 
			e.stop(); 
			if(current_fs > 70) { 
				content_fx.start(current_fs - 10); 
				current_fs -= 10; 
			} 
		});
	}
	// K2 font-size switcher fix
	if(document.id('fontIncrease') && document.getElement('.itemIntroText')) {
		document.id('fontIncrease').addEvent('click', function() {
			document.getElement('.itemIntroText').set('class', 'itemIntroText largerFontSize');
		});
		
		document.id('fontDecrease').addEvent('click', function() {
			document.getElement('.itemIntroText').set('class', 'itemIntroText smallerFontSize');
		});
	}	
    // gk-tablet animation
    if(document.getElement('.gk-tablet')) {
    	var tablets = document.getElements('.gk-tablet');

    	var tabletAnimate = function(tablet, wrapper, speed, interval, amount) {
    		
    		var state = parseInt(tablet.getProperty('data-state'), 10);
    		var dir = tablet.getProperty('data-dir');

    		if(dir == 'next' && state+1 >= amount) {
    			tablet.setProperty('data-dir', 'prev');
    			tablet.setProperty('data-state', --state);
    		} else if(dir == 'next' && state+1 < amount) {
    			tablet.setProperty('data-state', ++state);
    		} else if(dir == 'prev' && state-1 < 0) {
    			tablet.setProperty('data-dir', 'next');
    			tablet.setProperty('data-state', ++state);
    		} else {
    			tablet.setProperty('data-state', --state);
    		}

    		new Fx.Tween(wrapper, { 'duration': speed, 'unit': '%' }).start('margin-left', -100 * state);

    		setTimeout(function() {
    			tabletAnimate(tablet, wrapper, speed, interval, amount);
    		}, interval);	
    	};

    	tablets.forEach(function(tablet, i) {
    		// get basic informations
    		var amount = parseInt(tablet.getProperty('data-slides'), 10);
    		var speed = parseInt(tablet.getProperty('data-speed'), 10) || 500;
    		var interval = parseInt(tablet.getProperty('data-interval'), 10) || 3000;
    		var wrapper = tablet.getElement('div div');
    		// check if there is a screenshot to animate
    		if(amount > 1) {
	    		// set basic parameters
	    		tablet.setProperty('data-state', '0');
	    		tablet.setProperty('data-dir', 'next');
				// run the animation
				setTimeout(function() {
					tabletAnimate(tablet, wrapper, speed, interval, amount);
				}, interval);
			}
    	});
    }
});

window.addEvent('domready', function() {
	if (!Modernizr.svg) {
		document.getElements("img").each(function(item, i) {
			if(item.getProperty('data-fallback')) {
				item.setProperty("src", item.getProperty("data-fallback"));
			}
		});
	}
	
	gkReplaceImages();
});
// function to replace images depending from styles
function gkReplaceImages() {
	// replacing images
	document.getElements('img[data-styles="true"]').each(function(img) {
		var style = 1;
		for(var i = 1; i <= 4; i++) {
			if(document.body.hasClass('style'+i)) {
				style = i;
			}
		}
		img.setAttribute('src', img.getAttribute('src').replace(/\/style[1-4]{1,1}\//, '/style' + style + '/'));
	});
}

// function to set cookie
function setCookie(c_name, value, expire) {
	var exdate=new Date();
	exdate.setDate(exdate.getDate()+expire);
	document.cookie=c_name+ "=" +escape(value) + ((expire==null) ? "" : ";expires=" + exdate.toUTCString());
}
// Function to change styles
function changeStyle(style){
	var file1 = $GK_TMPL_URL+'/css/style'+style+'.css';
	var file2 = $GK_TMPL_URL+'/css/typography/typography.style'+style+'.css';
	new Asset.css(file1);
	new Asset.css(file2);
	Cookie.write('gk_mo_j25_style', style, { duration:365, path: '/' });
	
	for(var i = 1; i <= 4; i++) {
		document.getElement('body').removeClass('style' + i);
	}

	document.getElement('body').addClass('style' + style);
	gkReplaceImages();
}
